# -------------------------------------------
# Convenience Functions - Common Include File
# -------------------------------------------
#
RM_F() {
  local file=$1

  rm $file 2> /dev/null
  chmod 777 $file 2> /dev/null
  rm $file 2> /dev/null
}

RM_RF() {
  local directory=$1

  chmod 777 $directory 2> /dev/null
  rm -r $directory 2> /dev/null
}

RM_RF_SUBDIRS() {
  local dirname=$1
  local subdirname=

  for subdirname in $(ls $dirname 2> /dev/null) ; do
    RM_RF $subdirname
  done
}

SET_OWN_PERM() {
  local file=$1
  local ownergrp=$2
  local perm=$3

  chown $ownergrp $file
  chmod $perm $file
}

MV_F() {
  local srcfile=$1
  local dstfile=$2

  RM_F $dstfile
  mv $srcfile $dstfile
}

CP_F() {
  local srcfile=$1
  local dstfile=$2

  RM_F $dstfile
  cat $srcfile > $dstfile
}

CP_F_OWN_PERM() {
  CP_F $1 $2
  SET_OWN_PERM $2 $3 $4
}

LN_S_F() {
  local srcfile=$1
  local dstfile=$2

  RM_F $dstfile
  ln -s $srcfile $dstfile
}

